import SvgIcon from '@elementor/ui/SvgIcon';
import { useSettings } from '@ea11y/hooks';

function AccessibilityTextIcon(props) {
	const { iconDesign } = useSettings();
	const strokeColor = `lch(from ${iconDesign?.color || '#fff'} calc((50 - l) * 100) 0 0)`;
	return (
		<SvgIcon viewBox="0 0 125 65" fill="none" {...props}>
			<rect width="124" height="64" rx="4" />
			<rect
				x="7.5"
				y="7.5"
				width="109"
				height="49"
				rx="2.5"
				stroke={strokeColor}
				strokeWidth="3"
			/>
			<path
				d="M105.058 35.0469L107.3 27.5469H109.714L106.316 37.2734C106.243 37.487 106.144 37.7161 106.019 37.9609C105.899 38.2057 105.735 38.4375 105.527 38.6562C105.323 38.8802 105.066 39.0625 104.753 39.2031C104.446 39.3438 104.068 39.4141 103.62 39.4141C103.407 39.4141 103.232 39.401 103.097 39.375C102.962 39.349 102.8 39.3125 102.613 39.2656V37.6172C102.67 37.6172 102.73 37.6172 102.792 37.6172C102.855 37.6224 102.915 37.625 102.972 37.625C103.269 37.625 103.511 37.5911 103.698 37.5234C103.886 37.4557 104.037 37.3516 104.152 37.2109C104.266 37.0755 104.357 36.8984 104.425 36.6797L105.058 35.0469ZM104.12 27.5469L105.956 33.6719L106.277 36.0547L104.745 36.2188L101.706 27.5469H104.12Z"
				fill={strokeColor}
			/>
			<path
				d="M101.119 27.5469V29.1406H96.1969V27.5469H101.119ZM97.4156 25.4609H99.6656V33.4531C99.6656 33.6979 99.6969 33.8854 99.7594 34.0156C99.8271 34.1458 99.9261 34.237 100.056 34.2891C100.186 34.3359 100.351 34.3594 100.548 34.3594C100.689 34.3594 100.814 34.3542 100.923 34.3438C101.038 34.3281 101.134 34.3125 101.213 34.2969L101.22 35.9531C101.028 36.0156 100.819 36.0651 100.595 36.1016C100.371 36.138 100.124 36.1562 99.8531 36.1562C99.3584 36.1562 98.9261 36.0755 98.5563 35.9141C98.1917 35.7474 97.9104 35.4818 97.7125 35.1172C97.5146 34.7526 97.4156 34.2734 97.4156 33.6797V25.4609Z"
				fill={strokeColor}
			/>
			<path
				d="M94.9688 27.5469V36H92.7109V27.5469H94.9688ZM92.5703 25.3438C92.5703 25.0156 92.6849 24.7448 92.9141 24.5312C93.1432 24.3177 93.4505 24.2109 93.8359 24.2109C94.2161 24.2109 94.5208 24.3177 94.75 24.5312C94.9844 24.7448 95.1016 25.0156 95.1016 25.3438C95.1016 25.6719 94.9844 25.9427 94.75 26.1562C94.5208 26.3698 94.2161 26.4766 93.8359 26.4766C93.4505 26.4766 93.1432 26.3698 92.9141 26.1562C92.6849 25.9427 92.5703 25.6719 92.5703 25.3438Z"
				fill={strokeColor}
			/>
			<path d="M90.5844 24V36H88.3265V24H90.5844Z" fill={strokeColor} />
			<path
				d="M86.2 27.5469V36H83.9421V27.5469H86.2ZM83.8015 25.3438C83.8015 25.0156 83.9161 24.7448 84.1453 24.5312C84.3744 24.3177 84.6817 24.2109 85.0671 24.2109C85.4473 24.2109 85.752 24.3177 85.9812 24.5312C86.2156 24.7448 86.3328 25.0156 86.3328 25.3438C86.3328 25.6719 86.2156 25.9427 85.9812 26.1562C85.752 26.3698 85.4473 26.4766 85.0671 26.4766C84.6817 26.4766 84.3744 26.3698 84.1453 26.1562C83.9161 25.9427 83.8015 25.6719 83.8015 25.3438Z"
				fill={strokeColor}
			/>
			<path
				d="M74.675 24H76.925V34.0625L76.6985 36H74.675V24ZM82.2766 31.6875V31.8516C82.2766 32.4818 82.2089 33.0599 82.0735 33.5859C81.9433 34.112 81.7402 34.5677 81.4641 34.9531C81.1881 35.3333 80.8443 35.6302 80.4329 35.8438C80.0266 36.0521 79.5474 36.1562 78.9954 36.1562C78.4797 36.1562 78.0318 36.0521 77.6516 35.8438C77.2766 35.6354 76.9615 35.3411 76.7063 34.9609C76.4511 34.5807 76.2454 34.1354 76.0891 33.625C75.9329 33.1146 75.8157 32.5573 75.7375 31.9531V31.5938C75.8157 30.9896 75.9329 30.4323 76.0891 29.9219C76.2454 29.4115 76.4511 28.9661 76.7063 28.5859C76.9615 28.2057 77.2766 27.9115 77.6516 27.7031C78.0266 27.4948 78.4693 27.3906 78.9797 27.3906C79.537 27.3906 80.0214 27.4974 80.4329 27.7109C80.8495 27.9193 81.1933 28.2161 81.4641 28.6016C81.7402 28.9818 81.9433 29.4349 82.0735 29.9609C82.2089 30.4818 82.2766 31.0573 82.2766 31.6875ZM80.0266 31.8516V31.6875C80.0266 31.3438 80.0006 31.0208 79.9485 30.7188C79.9016 30.4115 79.8183 30.1432 79.6985 29.9141C79.5787 29.6797 79.4146 29.4948 79.2063 29.3594C79.0032 29.224 78.7402 29.1562 78.4172 29.1562C78.1099 29.1562 77.8495 29.2083 77.636 29.3125C77.4224 29.4167 77.2454 29.5625 77.1047 29.75C76.9693 29.9375 76.8678 30.1615 76.8 30.4219C76.7323 30.6771 76.6907 30.9583 76.675 31.2656V32.2891C76.6907 32.7005 76.7584 33.0651 76.8782 33.3828C77.0032 33.6953 77.1907 33.9427 77.4407 34.125C77.6959 34.3021 78.0266 34.3906 78.4329 34.3906C78.7506 34.3906 79.0136 34.3281 79.2219 34.2031C79.4303 34.0781 79.5917 33.901 79.7063 33.6719C79.8261 33.4427 79.9094 33.1745 79.9563 32.8672C80.0032 32.5547 80.0266 32.2161 80.0266 31.8516Z"
				fill={strokeColor}
			/>
			<path
				d="M72.6656 27.5469V36H70.4078V27.5469H72.6656ZM70.2672 25.3438C70.2672 25.0156 70.3818 24.7448 70.611 24.5312C70.8401 24.3177 71.1474 24.2109 71.5328 24.2109C71.913 24.2109 72.2177 24.3177 72.4469 24.5312C72.6813 24.7448 72.7985 25.0156 72.7985 25.3438C72.7985 25.6719 72.6813 25.9427 72.4469 26.1562C72.2177 26.3698 71.913 26.4766 71.5328 26.4766C71.1474 26.4766 70.8401 26.3698 70.611 26.1562C70.3818 25.9427 70.2672 25.6719 70.2672 25.3438Z"
				fill={strokeColor}
			/>
			<path
				d="M66.4922 33.6641C66.4922 33.5026 66.4453 33.3568 66.3516 33.2266C66.2578 33.0964 66.0833 32.9766 65.8281 32.8672C65.5781 32.7526 65.2161 32.6484 64.7422 32.5547C64.3151 32.4609 63.9167 32.3438 63.5469 32.2031C63.1823 32.0573 62.8646 31.8828 62.5938 31.6797C62.3281 31.4766 62.1198 31.237 61.9688 30.9609C61.8177 30.6797 61.7422 30.3594 61.7422 30C61.7422 29.6458 61.8177 29.3125 61.9688 29C62.125 28.6875 62.3464 28.4115 62.6328 28.1719C62.9245 27.9271 63.2786 27.737 63.6953 27.6016C64.1172 27.4609 64.5911 27.3906 65.1172 27.3906C65.8516 27.3906 66.4818 27.5078 67.0078 27.7422C67.5391 27.9766 67.9453 28.2995 68.2266 28.7109C68.513 29.1172 68.6562 29.5807 68.6562 30.1016H66.4062C66.4062 29.8828 66.3594 29.6875 66.2656 29.5156C66.1771 29.3385 66.0365 29.2005 65.8438 29.1016C65.6562 28.9974 65.4115 28.9453 65.1094 28.9453C64.8594 28.9453 64.6432 28.9896 64.4609 29.0781C64.2786 29.1615 64.138 29.276 64.0391 29.4219C63.9453 29.5625 63.8984 29.7188 63.8984 29.8906C63.8984 30.0208 63.9245 30.138 63.9766 30.2422C64.0339 30.3411 64.125 30.4323 64.25 30.5156C64.375 30.599 64.5365 30.6771 64.7344 30.75C64.9375 30.8177 65.1875 30.8802 65.4844 30.9375C66.0938 31.0625 66.638 31.2266 67.1172 31.4297C67.5964 31.6276 67.9766 31.8984 68.2578 32.2422C68.5391 32.5807 68.6797 33.026 68.6797 33.5781C68.6797 33.9531 68.5964 34.2969 68.4297 34.6094C68.263 34.9219 68.0234 35.1953 67.7109 35.4297C67.3984 35.6589 67.0234 35.8385 66.5859 35.9688C66.1536 36.0938 65.6667 36.1562 65.125 36.1562C64.3385 36.1562 63.6719 36.0156 63.125 35.7344C62.5833 35.4531 62.1719 35.0964 61.8906 34.6641C61.6146 34.2266 61.4766 33.7786 61.4766 33.3203H63.6094C63.6198 33.6276 63.6979 33.875 63.8438 34.0625C63.9948 34.25 64.1849 34.3854 64.4141 34.4688C64.6484 34.5521 64.901 34.5938 65.1719 34.5938C65.4635 34.5938 65.7057 34.5547 65.8984 34.4766C66.0911 34.3932 66.237 34.2839 66.3359 34.1484C66.4401 34.0078 66.4922 33.8464 66.4922 33.6641Z"
				fill={strokeColor}
			/>
			<path
				d="M58.1234 33.6641C58.1234 33.5026 58.0765 33.3568 57.9828 33.2266C57.889 33.0964 57.7146 32.9766 57.4594 32.8672C57.2094 32.7526 56.8474 32.6484 56.3734 32.5547C55.9463 32.4609 55.5479 32.3438 55.1781 32.2031C54.8135 32.0573 54.4958 31.8828 54.225 31.6797C53.9594 31.4766 53.751 31.237 53.6 30.9609C53.4489 30.6797 53.3734 30.3594 53.3734 30C53.3734 29.6458 53.4489 29.3125 53.6 29C53.7562 28.6875 53.9776 28.4115 54.264 28.1719C54.5557 27.9271 54.9099 27.737 55.3265 27.6016C55.7484 27.4609 56.2224 27.3906 56.7484 27.3906C57.4828 27.3906 58.113 27.5078 58.639 27.7422C59.1703 27.9766 59.5765 28.2995 59.8578 28.7109C60.1442 29.1172 60.2875 29.5807 60.2875 30.1016H58.0375C58.0375 29.8828 57.9906 29.6875 57.8969 29.5156C57.8083 29.3385 57.6677 29.2005 57.475 29.1016C57.2875 28.9974 57.0427 28.9453 56.7406 28.9453C56.4906 28.9453 56.2745 28.9896 56.0922 29.0781C55.9099 29.1615 55.7692 29.276 55.6703 29.4219C55.5765 29.5625 55.5297 29.7188 55.5297 29.8906C55.5297 30.0208 55.5557 30.138 55.6078 30.2422C55.6651 30.3411 55.7562 30.4323 55.8812 30.5156C56.0062 30.599 56.1677 30.6771 56.3656 30.75C56.5687 30.8177 56.8187 30.8802 57.1156 30.9375C57.725 31.0625 58.2692 31.2266 58.7484 31.4297C59.2276 31.6276 59.6078 31.8984 59.889 32.2422C60.1703 32.5807 60.3109 33.026 60.3109 33.5781C60.3109 33.9531 60.2276 34.2969 60.0609 34.6094C59.8942 34.9219 59.6547 35.1953 59.3422 35.4297C59.0297 35.6589 58.6547 35.8385 58.2172 35.9688C57.7849 36.0938 57.2979 36.1562 56.7562 36.1562C55.9698 36.1562 55.3031 36.0156 54.7562 35.7344C54.2146 35.4531 53.8031 35.0964 53.5219 34.6641C53.2458 34.2266 53.1078 33.7786 53.1078 33.3203H55.2406C55.251 33.6276 55.3291 33.875 55.475 34.0625C55.626 34.25 55.8161 34.3854 56.0453 34.4688C56.2797 34.5521 56.5323 34.5938 56.8031 34.5938C57.0948 34.5938 57.337 34.5547 57.5297 34.4766C57.7224 34.3932 57.8682 34.2839 57.9672 34.1484C58.0713 34.0078 58.1234 33.8464 58.1234 33.6641Z"
				fill={strokeColor}
			/>
			<path
				d="M48.6531 36.1562C47.9968 36.1562 47.4083 36.0521 46.8875 35.8438C46.3666 35.6302 45.9239 35.3359 45.5593 34.9609C45.2 34.5859 44.9239 34.151 44.7312 33.6562C44.5385 33.1562 44.4421 32.625 44.4421 32.0625V31.75C44.4421 31.1094 44.5333 30.5234 44.7156 29.9922C44.8979 29.4609 45.1583 29 45.4968 28.6094C45.8406 28.2188 46.2572 27.9193 46.7468 27.7109C47.2364 27.4974 47.7885 27.3906 48.4031 27.3906C49.002 27.3906 49.5333 27.4896 49.9968 27.6875C50.4604 27.8854 50.8484 28.1667 51.1609 28.5312C51.4786 28.8958 51.7182 29.3333 51.8796 29.8438C52.0411 30.349 52.1218 30.9115 52.1218 31.5312V32.4688H45.4031V30.9688H49.9109V30.7969C49.9109 30.4844 49.8536 30.2057 49.739 29.9609C49.6296 29.7109 49.463 29.513 49.239 29.3672C49.0151 29.2214 48.7286 29.1484 48.3796 29.1484C48.0828 29.1484 47.8276 29.2135 47.614 29.3438C47.4005 29.474 47.226 29.6562 47.0906 29.8906C46.9604 30.125 46.8614 30.401 46.7937 30.7188C46.7312 31.0312 46.7 31.375 46.7 31.75V32.0625C46.7 32.401 46.7468 32.7135 46.8406 33C46.9395 33.2865 47.0776 33.5339 47.2546 33.7422C47.4369 33.9505 47.6557 34.112 47.9109 34.2266C48.1713 34.3411 48.4656 34.3984 48.7937 34.3984C49.2 34.3984 49.5776 34.3203 49.9265 34.1641C50.2807 34.0026 50.5854 33.7604 50.8406 33.4375L51.9343 34.625C51.7572 34.8802 51.5151 35.125 51.2078 35.3594C50.9057 35.5938 50.5411 35.7865 50.114 35.9375C49.6869 36.0833 49.2 36.1562 48.6531 36.1562Z"
				fill={strokeColor}
			/>
			<path
				d="M39.761 34.3984C40.037 34.3984 40.2818 34.3464 40.4954 34.2422C40.7089 34.1328 40.8756 33.9818 40.9954 33.7891C41.1204 33.5911 41.1855 33.3594 41.1907 33.0938H43.3079C43.3027 33.6875 43.1438 34.2161 42.8313 34.6797C42.5188 35.138 42.0995 35.5 41.5735 35.7656C41.0474 36.026 40.4589 36.1562 39.8079 36.1562C39.1516 36.1562 38.5787 36.0469 38.0891 35.8281C37.6047 35.6094 37.2011 35.3073 36.8782 34.9219C36.5553 34.5312 36.3131 34.0781 36.1516 33.5625C35.9902 33.0417 35.9094 32.4844 35.9094 31.8906V31.6641C35.9094 31.0651 35.9902 30.5078 36.1516 29.9922C36.3131 29.4714 36.5553 29.0182 36.8782 28.6328C37.2011 28.2422 37.6047 27.9375 38.0891 27.7188C38.5735 27.5 39.1412 27.3906 39.7922 27.3906C40.4849 27.3906 41.0917 27.5234 41.6125 27.7891C42.1386 28.0547 42.55 28.4349 42.8469 28.9297C43.149 29.4193 43.3027 30 43.3079 30.6719H41.1907C41.1855 30.3906 41.1256 30.1354 41.011 29.9062C40.9016 29.6771 40.7402 29.4948 40.5266 29.3594C40.3183 29.2188 40.0605 29.1484 39.7532 29.1484C39.425 29.1484 39.1568 29.2188 38.9485 29.3594C38.7402 29.4948 38.5787 29.6823 38.4641 29.9219C38.3495 30.1562 38.2688 30.4245 38.2219 30.7266C38.1803 31.0234 38.1594 31.3359 38.1594 31.6641V31.8906C38.1594 32.2188 38.1803 32.5339 38.2219 32.8359C38.2636 33.138 38.3417 33.4062 38.4563 33.6406C38.5761 33.875 38.7402 34.0599 38.9485 34.1953C39.1568 34.3307 39.4277 34.3984 39.761 34.3984Z"
				fill={strokeColor}
			/>
			<path
				d="M31.2672 34.3984C31.5433 34.3984 31.788 34.3464 32.0016 34.2422C32.2151 34.1328 32.3818 33.9818 32.5016 33.7891C32.6266 33.5911 32.6917 33.3594 32.6969 33.0938H34.8141C34.8089 33.6875 34.65 34.2161 34.3375 34.6797C34.025 35.138 33.6058 35.5 33.0797 35.7656C32.5537 36.026 31.9651 36.1562 31.3141 36.1562C30.6578 36.1562 30.0849 36.0469 29.5953 35.8281C29.111 35.6094 28.7073 35.3073 28.3844 34.9219C28.0615 34.5312 27.8193 34.0781 27.6578 33.5625C27.4964 33.0417 27.4156 32.4844 27.4156 31.8906V31.6641C27.4156 31.0651 27.4964 30.5078 27.6578 29.9922C27.8193 29.4714 28.0615 29.0182 28.3844 28.6328C28.7073 28.2422 29.111 27.9375 29.5953 27.7188C30.0797 27.5 30.6474 27.3906 31.2985 27.3906C31.9912 27.3906 32.5979 27.5234 33.1188 27.7891C33.6448 28.0547 34.0563 28.4349 34.3531 28.9297C34.6552 29.4193 34.8089 30 34.8141 30.6719H32.6969C32.6917 30.3906 32.6318 30.1354 32.5172 29.9062C32.4078 29.6771 32.2464 29.4948 32.0328 29.3594C31.8245 29.2188 31.5667 29.1484 31.2594 29.1484C30.9313 29.1484 30.663 29.2188 30.4547 29.3594C30.2464 29.4948 30.0849 29.6823 29.9703 29.9219C29.8558 30.1562 29.775 30.4245 29.7281 30.7266C29.6865 31.0234 29.6656 31.3359 29.6656 31.6641V31.8906C29.6656 32.2188 29.6865 32.5339 29.7281 32.8359C29.7698 33.138 29.8479 33.4062 29.9625 33.6406C30.0823 33.875 30.2464 34.0599 30.4547 34.1953C30.663 34.3307 30.9339 34.3984 31.2672 34.3984Z"
				fill={strokeColor}
			/>
			<path
				d="M21.6406 26.5703L18.5469 36H16.0547L20.2812 24.625H21.8672L21.6406 26.5703ZM24.2109 36L21.1094 26.5703L20.8594 24.625H22.4609L26.7109 36H24.2109ZM24.0703 31.7656V33.6016H18.0625V31.7656H24.0703Z"
				fill={strokeColor}
			/>
		</SvgIcon>
	);
}

export default AccessibilityTextIcon;
