import { registerBlockType, registerBlockVariation } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';
import { Edit } from './edit';
import metadata from './block.json';
import { Save } from './save';
import { getIcon } from '@utils';

registerBlockType( metadata, {
	edit: Edit,
	save: Save,
	icon: getIcon( 'shape' ),
} );

registerBlockVariation(
	'generateblocks/shape',
	{
		name: 'generateblocks/shape',
		description: __( 'Add a shape to your page.', 'generateblocks' ),
		title: 'Shape',
		attributes: {
			html: '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" aria-hidden="true"><path d="M22,11.5L12.5,11.5L12.5,2L22,2L22,11.5ZM13.75,3.25L13.75,10.25L20.75,10.25L20.75,3.25L13.75,3.25Z" /><path d="M6.811,12.5L6.873,12.502L6.933,12.503L6.994,12.506L7.055,12.51L7.115,12.514L7.175,12.519L7.235,12.525L7.295,12.531L7.355,12.538L7.414,12.546L7.473,12.555L7.59,12.574L7.707,12.597L7.822,12.622L7.937,12.65L8.05,12.68L8.162,12.714L8.273,12.75L8.383,12.788L8.491,12.83L8.598,12.874L8.704,12.92L8.809,12.969L8.912,13.02L9.013,13.074L9.114,13.13L9.212,13.188L9.309,13.249L9.405,13.312L9.499,13.377L9.591,13.444L9.682,13.514L9.771,13.585L9.858,13.659L9.943,13.735L10.027,13.812L10.108,13.892L10.188,13.973L10.265,14.057L10.341,14.142L10.415,14.229L10.486,14.318L10.556,14.409L10.623,14.501L10.688,14.595L10.751,14.691L10.812,14.788L10.87,14.886L10.926,14.987L10.98,15.088L11.031,15.191L11.08,15.296L11.126,15.402L11.17,15.509L11.212,15.617L11.25,15.727L11.286,15.838L11.32,15.95L11.35,16.063L11.378,16.178L11.403,16.293L11.426,16.41L11.445,16.527L11.454,16.586L11.462,16.645L11.469,16.705L11.475,16.765L11.481,16.825L11.486,16.885L11.49,16.945L11.494,17.006L11.497,17.067L11.498,17.127L11.5,17.189L11.5,17.25L11.5,17.311L11.498,17.373L11.497,17.433L11.494,17.494L11.49,17.555L11.486,17.615L11.481,17.675L11.475,17.735L11.469,17.795L11.462,17.855L11.454,17.914L11.445,17.973L11.426,18.09L11.403,18.207L11.378,18.322L11.35,18.437L11.32,18.55L11.286,18.662L11.25,18.773L11.212,18.883L11.17,18.991L11.126,19.098L11.08,19.204L11.031,19.309L10.98,19.412L10.926,19.513L10.87,19.614L10.812,19.712L10.751,19.809L10.688,19.905L10.623,19.999L10.556,20.091L10.486,20.182L10.415,20.271L10.341,20.358L10.265,20.443L10.188,20.527L10.108,20.608L10.027,20.688L9.943,20.765L9.858,20.841L9.771,20.915L9.682,20.986L9.591,21.056L9.499,21.123L9.405,21.188L9.309,21.251L9.212,21.312L9.114,21.37L9.013,21.426L8.912,21.48L8.809,21.531L8.704,21.58L8.598,21.626L8.491,21.67L8.383,21.712L8.273,21.75L8.162,21.786L8.05,21.82L7.937,21.85L7.822,21.878L7.707,21.903L7.59,21.926L7.473,21.945L7.414,21.954L7.355,21.962L7.295,21.969L7.235,21.975L7.175,21.981L7.115,21.986L7.055,21.99L6.994,21.994L6.933,21.997L6.873,21.998L6.811,22L6.75,22L6.689,22L6.627,21.998L6.567,21.997L6.506,21.994L6.445,21.99L6.385,21.986L6.325,21.981L6.265,21.975L6.205,21.969L6.145,21.962L6.086,21.954L6.027,21.945L5.91,21.926L5.793,21.903L5.678,21.878L5.563,21.85L5.45,21.82L5.338,21.786L5.227,21.75L5.117,21.712L5.009,21.67L4.902,21.626L4.796,21.58L4.691,21.531L4.588,21.48L4.487,21.426L4.386,21.37L4.288,21.312L4.191,21.251L4.095,21.188L4.001,21.123L3.909,21.056L3.818,20.986L3.729,20.915L3.642,20.841L3.557,20.765L3.473,20.688L3.392,20.608L3.312,20.527L3.235,20.443L3.159,20.358L3.085,20.271L3.014,20.182L2.944,20.091L2.877,19.999L2.812,19.905L2.749,19.809L2.688,19.712L2.63,19.614L2.574,19.513L2.52,19.412L2.469,19.309L2.42,19.204L2.374,19.098L2.33,18.991L2.288,18.883L2.25,18.773L2.214,18.662L2.18,18.55L2.15,18.437L2.122,18.322L2.097,18.207L2.074,18.09L2.055,17.973L2.046,17.914L2.038,17.855L2.031,17.795L2.025,17.735L2.019,17.675L2.014,17.615L2.01,17.555L2.006,17.494L2.003,17.433L2.002,17.373L2,17.311L2,17.25L2,17.189L2.002,17.127L2.003,17.067L2.006,17.006L2.01,16.945L2.014,16.885L2.019,16.825L2.025,16.765L2.031,16.705L2.038,16.645L2.046,16.586L2.055,16.527L2.074,16.41L2.097,16.293L2.122,16.178L2.15,16.063L2.18,15.95L2.214,15.838L2.25,15.727L2.288,15.617L2.33,15.509L2.374,15.402L2.42,15.296L2.469,15.191L2.52,15.088L2.574,14.987L2.63,14.886L2.688,14.788L2.749,14.691L2.812,14.595L2.877,14.501L2.944,14.409L3.014,14.318L3.085,14.229L3.159,14.142L3.235,14.057L3.312,13.973L3.392,13.892L3.473,13.812L3.557,13.735L3.642,13.659L3.729,13.585L3.818,13.514L3.909,13.444L4.001,13.377L4.095,13.312L4.191,13.249L4.288,13.188L4.386,13.13L4.487,13.074L4.588,13.02L4.691,12.969L4.796,12.92L4.902,12.874L5.009,12.83L5.117,12.788L5.227,12.75L5.338,12.714L5.45,12.68L5.563,12.65L5.678,12.622L5.793,12.597L5.91,12.574L6.027,12.555L6.086,12.546L6.145,12.538L6.205,12.531L6.265,12.525L6.325,12.519L6.385,12.514L6.445,12.51L6.506,12.506L6.567,12.503L6.627,12.502L6.689,12.5L6.75,12.5L6.811,12.5ZM6.66,13.751L6.57,13.755L6.481,13.76L6.392,13.768L6.304,13.778L6.217,13.79L6.131,13.805L6.045,13.821L5.96,13.84L5.876,13.86L5.792,13.883L5.71,13.907L5.628,13.934L5.547,13.963L5.467,13.993L5.388,14.025L5.31,14.059L5.233,14.095L5.157,14.133L5.082,14.173L5.008,14.214L4.936,14.257L4.864,14.302L4.794,14.348L4.724,14.396L4.656,14.446L4.59,14.497L4.524,14.55L4.46,14.604L4.397,14.66L4.336,14.717L4.276,14.776L4.217,14.836L4.16,14.897L4.104,14.96L4.05,15.024L3.997,15.09L3.946,15.156L3.896,15.224L3.848,15.294L3.802,15.364L3.757,15.436L3.714,15.508L3.673,15.582L3.633,15.657L3.595,15.733L3.559,15.81L3.525,15.888L3.493,15.967L3.463,16.047L3.434,16.128L3.407,16.21L3.383,16.292L3.36,16.376L3.34,16.46L3.321,16.545L3.305,16.631L3.29,16.717L3.278,16.804L3.268,16.892L3.26,16.981L3.255,17.07L3.251,17.16L3.25,17.25L3.251,17.34L3.255,17.43L3.26,17.519L3.268,17.608L3.278,17.696L3.29,17.783L3.305,17.869L3.321,17.955L3.34,18.04L3.36,18.124L3.383,18.208L3.407,18.29L3.434,18.372L3.463,18.453L3.493,18.533L3.525,18.612L3.559,18.69L3.595,18.767L3.633,18.843L3.673,18.918L3.714,18.992L3.757,19.064L3.802,19.136L3.848,19.206L3.896,19.276L3.946,19.344L3.997,19.41L4.05,19.476L4.104,19.54L4.16,19.603L4.217,19.664L4.276,19.724L4.336,19.783L4.397,19.84L4.46,19.896L4.524,19.95L4.59,20.003L4.656,20.054L4.724,20.104L4.794,20.152L4.864,20.198L4.936,20.243L5.008,20.286L5.082,20.327L5.157,20.367L5.233,20.405L5.31,20.441L5.388,20.475L5.467,20.507L5.547,20.537L5.628,20.566L5.71,20.593L5.792,20.617L5.876,20.64L5.96,20.66L6.045,20.679L6.131,20.695L6.217,20.71L6.304,20.722L6.392,20.732L6.481,20.74L6.57,20.745L6.66,20.749L6.75,20.75L6.84,20.749L6.93,20.745L7.019,20.74L7.108,20.732L7.196,20.722L7.283,20.71L7.369,20.695L7.455,20.679L7.54,20.66L7.624,20.64L7.708,20.617L7.79,20.593L7.872,20.566L7.953,20.537L8.033,20.507L8.112,20.475L8.19,20.441L8.267,20.405L8.343,20.367L8.418,20.327L8.492,20.286L8.564,20.243L8.636,20.198L8.706,20.152L8.776,20.104L8.844,20.054L8.91,20.003L8.976,19.95L9.04,19.896L9.103,19.84L9.164,19.783L9.224,19.724L9.283,19.664L9.34,19.603L9.396,19.54L9.45,19.476L9.503,19.41L9.554,19.344L9.604,19.276L9.652,19.206L9.698,19.136L9.743,19.064L9.786,18.992L9.827,18.918L9.867,18.843L9.905,18.767L9.941,18.69L9.975,18.612L10.007,18.533L10.037,18.453L10.066,18.372L10.093,18.29L10.117,18.208L10.14,18.124L10.16,18.04L10.179,17.955L10.195,17.869L10.21,17.783L10.222,17.696L10.232,17.608L10.24,17.519L10.245,17.43L10.249,17.34L10.25,17.25L10.249,17.16L10.245,17.07L10.24,16.981L10.232,16.892L10.222,16.804L10.21,16.717L10.195,16.631L10.179,16.545L10.16,16.46L10.14,16.376L10.117,16.292L10.093,16.21L10.066,16.128L10.037,16.047L10.007,15.967L9.975,15.888L9.941,15.81L9.905,15.733L9.867,15.657L9.827,15.582L9.786,15.508L9.743,15.436L9.698,15.364L9.652,15.294L9.604,15.224L9.554,15.156L9.503,15.09L9.45,15.024L9.396,14.96L9.34,14.897L9.283,14.836L9.224,14.776L9.164,14.717L9.103,14.66L9.04,14.604L8.976,14.55L8.91,14.497L8.844,14.446L8.776,14.396L8.706,14.348L8.636,14.302L8.564,14.257L8.492,14.214L8.418,14.173L8.343,14.133L8.267,14.095L8.19,14.059L8.112,14.025L8.033,13.993L7.953,13.963L7.872,13.934L7.79,13.907L7.708,13.883L7.624,13.86L7.54,13.84L7.455,13.821L7.369,13.805L7.283,13.79L7.196,13.778L7.108,13.768L7.019,13.76L6.93,13.755L6.84,13.751L6.75,13.75L6.66,13.751Z" /><path d="M11.5,11.5L2,11.5L6.75,2C8.333,5.167 9.917,8.333 11.5,11.5ZM4.023,10.25L9.477,10.25L6.75,4.795C5.841,6.613 4.932,8.432 4.023,10.25Z" /><path d="M22,14.875L19.625,17.25L22,19.625L19.625,22L17.25,19.625L14.875,22L12.5,19.625L14.875,17.25L12.5,14.875L14.875,12.5L17.25,14.875L19.625,12.5C20.417,13.292 21.208,14.083 22,14.875ZM18.134,15.759C17.647,16.22 16.86,16.226 16.366,15.759L14.875,14.268L14.268,14.875L15.759,16.366C16.22,16.853 16.226,17.64 15.759,18.134L14.268,19.625L14.875,20.232L16.366,18.741C16.855,18.278 17.645,18.278 18.134,18.741L19.625,20.232L20.232,19.625L18.741,18.134C18.28,17.647 18.274,16.86 18.741,16.366L20.232,14.875L19.625,14.268C19.128,14.765 18.631,15.262 18.134,15.759Z" /></svg>',
			styles: {
				display: 'inline-flex',
				svg: {
					fill: 'currentColor',
					height: '30px',
					width: '30px',
				},
			},
		},
		isDefault: true,
	},
);
